﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using hive;

namespace Game
{
	public enum PlayerState
	{
		Default,
		Move,
		Death
	}

	public class PlayerSettings
	{
		private static PlayerSettings _instance;

		public string sessionToken;
		// Game session token.
		// 업적/리더보드 사용 가능한 유저 여부.
		public bool canAchievement {
			get {
				AuthV4.PlayerInfo playerInfo = AuthV4.getPlayerInfo ();
				bool _canAchievement	= false;

				foreach (AuthV4.ProviderType providerType in playerInfo.providerInfoData.Keys) {
#if UNITY_ANDROID
				if (AuthV4.ProviderType.GOOGLE == providerType) {
					_canAchievement	= true;
					break;
				}
#elif UNITY_IOS
					if (AuthV4.ProviderType.APPLE == providerType) {
						_canAchievement	= true;
						break;
					}
#endif // 
				}

				return _canAchievement;
			}
		}

		long _gold = 0;

		int _baseHealth = 100;
		// health 기본 값.
		int _maxHealth;
		// health 최대 값.
		int _healthLevel = 0;
		// health 레벨.
		int _healthMaxLevel	= 3;
		// health 최대 레벨.
		int _healthUpValue = 20;
		// health 레벨 업당 증가폭.

		float _baseSpeed = 4f;
		// speed 기본 값.
		float _maxSpeed;
		// speed 최대 값.
		int _speedLevel;
		// speed 레벨.
		int _speedMaxLevel	= 3;
		// speed 최대 레벨.
		float _speedUpValue = 0.2f;
		// speed 레벨 업당 증가폭.
	

		bool _superSuit;

		bool _devilSuit;

		List<GameNetwork.Item> _items;

		List<GameNetwork.Subscription> _subscriptions;


		public static PlayerSettings Instance ()
		{
			if (_instance == null) {
				_instance	= new PlayerSettings ();

				_instance._gold = 0;

				_instance.BaseHealth	= 100;
				_instance.HealthUpValue	= 20;

				_instance.BaseSpeed = 4f;
				_instance.SpeedUpValue	= 0.2f;

				_instance._superSuit = false;
				_instance._devilSuit = false;
			}

			return _instance;
		}

		public long Gold {
			get {
				return _gold;
			}
			set {
				_gold = value;
			}
		}

		public int MaxHealth {
			get {
				return _maxHealth;
			}
		}

		public bool IsMaxHealth {
			get {
				return (_healthLevel >= _healthMaxLevel);
			}
		}

		public float MaxSpeed {
			get {
				return _maxSpeed;
			}
		}

		public bool IsMaxSpeed {
			get {
				return (OriginalSpeed >= _speedMaxLevel);
			}
		}

		public int OriginalSpeed {
			get {
				if (_speedLevel <= 3) {
					return _speedLevel;
				} else if (_speedLevel <= 8) {
					return _speedLevel - 5;
				} else {
					return _speedLevel - 10;
				}
			}
		}

		public int BaseHealth {
			get {
				return _baseHealth;
			}

			set {
				_baseHealth	= value;
			}
		}

		public float BaseSpeed {
			get {
				return _baseSpeed;
			}

			set {
				_baseSpeed	= value;
			}
		}

		public int HealthLevel {
			set {
				_healthLevel	= value;

				UpdatePlayerHealth ();	
			}

			get {
				return _healthLevel;
			}
		}

		public int HealthUpValue {
			set {
				_healthUpValue	= value;

				UpdatePlayerHealth ();
			}

			get {
				return _healthUpValue;
			}
		}

		public int SpeedLevel {
			set {
				_speedLevel	= value;

				UpdatePlayerSpeed ();
			}

			get {
				return _speedLevel;
			}
		}

		public float SpeedUpValue {
			set {
				_speedUpValue	= value;

				UpdatePlayerSpeed ();
			}

			get {
				return _speedUpValue;
			}
		}

		public bool SuperSuit {
			set {
				_superSuit = value;
			}

			get {
				return _superSuit;
			}
		}

		public bool DevilSuit {
			set {
				_devilSuit = value;
			}

			get {
				return _devilSuit;
			}
		}

		// Subscriptions 와 관계없이 인게임에만 영향
		public List<GameNetwork.Item> Items {
			set {
				Gold = 0;
				HealthLevel = 0;
				SpeedLevel = 0;
				SuperSuit = false;
				DevilSuit = false;
				Subscriptions = null;
				_items = value;

				if (_items != null) {
					foreach (GameNetwork.Item item in _items) {
						if (string.Equals (item.code, "gold")) {
							Gold = item.amount;
						} else if (string.Equals (item.code, "health")) {
							HealthLevel = (int)item.amount;
						} else if (string.Equals (item.code, "speed")) {
							SpeedLevel = (int)item.amount;
						} else if (string.Equals (item.code, "super")) {
							SuperSuit = (int)item.amount > 0;
						} else if (string.Equals (item.code, "devil")) {
							DevilSuit = (int)item.amount > 0;
						}
					}
				}
			}

			get {
				return _items;
			}
		}

		// 상점 버튼 처리에만 영향
		public List<GameNetwork.Subscription> Subscriptions {
			set {
				_subscriptions = value;
			}

			get {
				return _subscriptions;
			}
		}


		void UpdatePlayerHealth ()
		{
			_maxHealth	= _baseHealth + (_healthLevel * _healthUpValue);
		}

		void UpdatePlayerSpeed ()
		{
			_maxSpeed	= _baseSpeed + (_speedLevel * _speedUpValue);
		}


		public void reset()
		{
			sessionToken = "";
			Gold = 0;
			HealthLevel = 0;
			SpeedLevel = 0;
			SuperSuit = false;
			DevilSuit = false;
			Subscriptions = null;
		}
	}
}
